define({"539":{y:0,u:"../Content/Lua/LuaHttpResponse/_LUA_get_http_code.htm",l:-1,t:"get_http_code",i:0.000526796252017684,a:"get_http_code The get_http_code method returns the HTTP response code for the request. Syntax get_http_code() Returns (number). The response code, for example 200 for success, or 404 for not found."},"540":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA__LuaJsonArray.htm",l:-1,t:"LuaJsonArray Methods",i:0.00223930694612461,a:"A LuaJsonArray object represents a JSON array. If you have a LuaJsonArray object called myJsonArray you can call its methods using the \u0027:\u0027 operator. For example: myJsonArray:size() Method Description append Appends a value to the array. clear Clears the array, so that it contains no values. copy ..."},"541":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_LuaJsonArray_new.htm",l:-1,t:"LuaJsonArray:new",i:0.000558577760712197,a:"The constructor for a LuaJsonArray object (creates a new LuaJsonArray). Syntax LuaJsonArray:new( values ) Arguments Returns (LuaJsonArray). The new LuaJsonArray object. Example The following is a simple JSON array: [4, \"a string\", true] To create a LuaJsonArray object to represent this array: local ..."},"542":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_append.htm",l:-1,t:"append",i:0.000558577760712197,a:"append The append method appends a value to the JSON array. Syntax append( value ) Arguments Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\nmyJsonArray:append(6)\n-- the array is now [4, \"a string\", true, 6]"},"543":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_clear.htm",l:-1,t:"clear",i:0.000558577760712197,a:"clear The clear method clears the array, so that it contains no values. Syntax clear() Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\nmyJsonArray:clear()\nprint (myJsonArray:string())\n-- []"},"544":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_copy.htm",l:-1,t:"copy",i:0.000558577760712197,a:"The copy method returns a copy of the array. Modifying the copy does not modify the original array. Syntax copy() Returns (LuaJsonArray). A copy of the array. Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\nlocal anotherJsonArray = myJsonArray:copy()\nprint ..."},"545":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_empty.htm",l:-1,t:"empty",i:0.000558577760712197,a:"The empty method checks whether the JSON array is empty. Syntax empty() Returns (Boolean). Returns true if the array is empty. Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\n\nprint (\"Is the array empty?  \" , myJsonArray:empty() )\n-- Is the array empty?   ..."},"546":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_exists.htm",l:-1,t:"exists",i:0.00372334500340223,a:"The exists method checks whether a specified path exists in the JSON array. Syntax exists( pathElements ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nlocal myJsonArray = ..."},"547":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_existsByPath.htm",l:-1,t:"existsByPath",i:0.00372334500340223,a:"The existsByPath method checks whether a specified path exists in the JSON array. Syntax existsByPath( path ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nlocal myJsonArray = ..."},"548":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_ipairs.htm",l:-1,t:"ipairs",i:0.000558577760712197,a:"The ipairs method returns a function that you can use with a for loop to iterate over all of the values in the array. Syntax ipairs() Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\n\nfor i, v in myJsonArray:ipairs() do\n  print (v:string())\nend\n\n-- prints the following...\n-- 4\n-- a ..."},"549":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_lookup.htm",l:-1,t:"lookup",i:0.00372334500340223,a:"The lookup method returns the value at the specified path in the JSON array. This method does not make a copy of the value, so modifying the returned value affects the original array. Syntax lookup( pathElements ) Arguments Returns (LuaJsonValue) Returns the value that exists at the specified path, ..."},"550":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_lookupByPath.htm",l:-1,t:"lookupByPath",i:0.00372334500340223,a:"The lookupByPath method returns the value at the specified path in the JSON array. This method does not make a copy of the value, so modifying the returned value affects the original array. Syntax lookupByPath( path ) Arguments Returns (LuaJsonValue) Returns the value that exists at the specified ..."},"551":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_size.htm",l:-1,t:"size",i:0.000558577760712197,a:"size The size method returns the size of the JSON array. Syntax size() Returns (integer). The number of values in the array. Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\nprint (\"Array size is \" , myJsonArray:size() )\n-- Array size is 3"},"552":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_string.htm",l:-1,t:"string",i:0.000558577760712197,a:"The string method returns the JSON array as a string. Syntax string() Returns (String). The array as a string. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nlocal myJsonArray = LuaJsonArray:new(\"zero\",1,2,myJsonObject)\n\nprint (myJsonArray:string())\n-- ..."},"553":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA__LuaJsonObject.htm",l:-1,t:"LuaJsonObject Methods",i:0.00223930694612461,a:"A LuaJsonObject object represents a JSON object. If you have a LuaJsonObject object called object you can call its methods using the \u0027:\u0027 operator. For example: object:size() Method Description assign Adds an attribute (a name/value pair) to the object. assign Adds a table of attributes (name/value ..."},"554":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_LuaJsonObject_new.htm",l:-1,t:"LuaJsonObject:new",i:0.00053591801687022,a:"The constructor for a LuaJsonObject object (creates a new LuaJsonObject). If you do not specify any attributes to assign to the object (by omitting the attributes argument), an empty object is created. Syntax LuaJsonObject:new( [attributes] ) Arguments Returns (LuaJsonObject). The new LuaJsonObject ..."},"555":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_assign.htm",l:-1,t:"assign",i:0.00053591801687022,a:"The assign method adds an attribute (a name/value pair) to the object. Syntax assign (name, value) Arguments Example local myJsonObject = LuaJsonObject:new( { name1=\"value1\" , name2=\"value2\" } )\nmyJsonObject:assign(\"name3\", \"value3\")\nmyJsonObject:assign(\"name4\", LuaJsonArray:new(\"value4a\",\"value4b\") ..."},"556":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_assign2.htm",l:-1,t:"assign",i:0.00053591801687022,a:"The assign method adds a table of attributes (name/value pairs) to the object. Syntax assign (attributes) Arguments Example local myJsonObject = LuaJsonObject:new()\nmyJsonObject:assign( {\n        attr1=LuaJsonObject:new( { n=42 } ),\n        attr2=LuaJsonArray:new( 1, 2, \"three\" ),\n        ..."},"557":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_clear.htm",l:-1,t:"clear",i:0.00053591801687022,a:"clear The clear method clears the object, so that it contains no attributes (name/value pairs). Syntax clear() Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nmyJsonObject:clear()\nprint (myJsonObject:string())\n-- {}"},"558":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_copy.htm",l:-1,t:"copy",i:0.00053591801687022,a:"The copy method returns a copy of the JSON object. Modifying the copy does not modify the original object. Syntax copy() Returns (LuaJsonObject). A copy of the object. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nlocal anotherJsonObject = ..."},"559":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_empty.htm",l:-1,t:"empty",i:0.00053591801687022,a:"empty The empty method determines whether the JSON object is empty. Syntax empty() Returns (Boolean). Returns true if the object has no attributes (name/value pairs). Example local myJsonObject = LuaJsonObject:new()\nprint(myJsonObject:empty())\n-- true\n"},"560":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_erase.htm",l:-1,t:"erase",i:0.00053591801687022,a:"erase The erase method removes a specified attribute (name/value pair) from the JSON object. Syntax erase( name ) Arguments Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nmyJsonObject:erase(\"version\")\nprint (myJsonObject:string())\n-- {\"product\":\"IDOL\"}"},"561":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_exists.htm",l:-1,t:"exists",i:0.00357230741536852,a:"The exists method checks whether a specified path exists in the JSON object. Syntax exists( pathElements ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example \nConsider the following JSON: \n{\n  \"product\": \"IDOL\",\n  \"component\": \"CFS\",\n  \"version\": { \"major\": 11, ..."},"562":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_existsByPath.htm",l:-1,t:"existsByPath",i:0.00357230741536852,a:"The existsByPath method checks whether a specified path exists in the JSON object. Syntax existsByPath( path ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example Consider the following JSON: \n{\n  \"product\": \"IDOL\",\n  \"component\": \"CFS\",\n  \"version\": { \"major\": 11, ..."},"563":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_lookup.htm",l:-1,t:"lookup",i:0.00357230741536852,a:"The lookup method returns the value at the specified path in the JSON object. This method does not make a copy of the value, so modifying the returned value affects the original object. Syntax lookup( pathElements ) Arguments Returns (LuaJsonValue) Returns the value that exists at the specified ..."},"564":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_lookupByPath.htm",l:-1,t:"lookupByPath",i:0.00357230741536852,a:"The lookupByPath method returns the value at the specified path in the JSON object. This method does not make a copy of the value, so modifying the returned value affects the original object. Syntax lookupByPath( path ) Arguments Returns (LuaJsonValue) Returns the value that exists at the specified ..."},"565":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_pairs.htm",l:-1,t:"pairs",i:0.00053591801687022,a:"The pairs method returns an iterator function that you can use with a for loop to iterate over all of the attributes contained in the JSON object. Syntax pairs() Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\n\nfor i, v in myJsonObject:pairs() do\n  print (i .. \u0027=\u0027 ..."},"566":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_size.htm",l:-1,t:"size",i:0.00053591801687022,a:"size The size method returns the number of attributes (name/value pairs) in the JSON object. Syntax size() Returns (Number). The number of attributes in the JSON object. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nprint (myJsonObject:size())\n-- 2"},"567":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_string.htm",l:-1,t:"string",i:0.00053591801687022,a:"string The string method returns the JSON object as a string. Syntax string() Returns (String). The JSON object as a string. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nprint (myJsonObject:string())\n-- {\"product\":\"IDOL\",\"version\":11}"},"568":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA__LuaJsonValue.htm",l:-1,t:"LuaJsonValue Methods",i:0.00187487042088113,a:"A LuaJsonValue object represents a JSON value.  If you have a LuaJsonValue object called myJsonValue you can call its methods using the \u0027:\u0027 operator. For example: myJsonValue:is_object() Method Description array Gets a LuaJsonArray that represents the JSON array, if the value is an array. copy ..."},"569":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_LuaJsonValue_new.htm",l:-1,t:"LuaJsonValue:new",i:0.00048383567593424,a:"LuaJsonValue:new The constructor for a LuaJsonValue object (creates a new LuaJsonValue). Syntax LuaJsonValue:new( value ) Arguments Returns (LuaJsonValue). The new LuaJsonValue object."},"570":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_array.htm",l:-1,t:"array",i:0.00048383567593424,a:"The array method gets the array, if the value is a JSON array. Syntax array() Returns (LuaJsonArray). A  LuaJsonArray  object that represents the array. Example local fh = io.open(\"example_array.json\", \"r\")\nlocal file_content = fh:read(\"*all\")\nfh:close()\n    \nlocal myJsonValue = ..."},"571":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_copy.htm",l:-1,t:"copy",i:0.00048383567593424,a:"copy The copy method returns a copy of the value. Modifying the copy does not affect the original value. Syntax copy() Returns (LuaJsonValue). A copy of the value."},"572":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_exists.htm",l:-1,t:"exists",i:0.00322515305959451,a:"The exists method checks whether a specified path exists in the JSON value. Syntax exists( pathElements ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example \nConsider the following JSON: \n{\n  \"product\": \"IDOL\",\n  \"component\": \"CFS\",\n  \"version\": { \"major\": 11, ..."},"573":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_existsByPath.htm",l:-1,t:"existsByPath",i:0.00322515305959451,a:"The existsByPath method checks whether a specified path exists in the JSON value.  Syntax existsByPath( path ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example Consider the following JSON: \n{\n  \"product\": \"IDOL\",\n  \"component\": \"CFS\",\n  \"version\": { \"major\": 11, ..."},"574":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_array.htm",l:-1,t:"is_array",i:0.00048383567593424,a:"is_array The is_array method whether the value is a JSON array. Syntax is_array() Returns (Boolean). Returns true if the value is an array value, false otherwise."},"575":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_boolean.htm",l:-1,t:"is_boolean",i:0.00048383567593424,a:"is_boolean The is_boolean method returns whether the value is a Boolean value. Syntax is_boolean() Returns (Boolean). Returns true if the value is a Boolean value, false otherwise."},"576":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_float.htm",l:-1,t:"is_float",i:0.00048383567593424,a:"is_float The is_float method returns whether the value is a floating point value. Syntax is_float() Returns (Boolean). Returns true if the value is a floating point value, false otherwise."},"577":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_integer.htm",l:-1,t:"is_integer",i:0.00048383567593424,a:"is_integer The is_integer method returns whether the value is an integral value. Syntax is_integer() Returns (Boolean). Returns true if the value is an integer value, false otherwise."},"578":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_null.htm",l:-1,t:"is_null",i:0.00048383567593424,a:"is_null The is_null method returns whether the value is a null value. Syntax is_null() Returns (Boolean). Returns true if the value is a null value, false otherwise."},"579":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_number.htm",l:-1,t:"is_number",i:0.00048383567593424,a:"is_number The is_number method returns whether the value is a number. Syntax is_number() Returns (Boolean). Returns true if the value is a number, false otherwise."},"580":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_object.htm",l:-1,t:"is_object",i:0.00048383567593424,a:"is_object The is_object method returns whether the value is a JSON object. Syntax is_object() Returns (Boolean). Returns true if the value is a JSON object, false otherwise."},"581":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_simple_value.htm",l:-1,t:"is_simple_value",i:0.00048383567593424,a:"is_simple_value The is_simple_value method returns whether the value is a simple value (Boolean, float, integer, or string). Syntax is_simple_value() Returns (Boolean). Returns true if the value is a simple value, false otherwise."},"582":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_string.htm",l:-1,t:"is_string",i:0.00048383567593424,a:"is_string The is_string method returns whether the value is a string value. Syntax is_string() Returns (Boolean). Returns true if the value is a string value, false otherwise."},"583":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_lookup.htm",l:-1,t:"lookup",i:0.00322515305959451,a:"The lookup method returns the value at the specified path in the JSON value. This method does not make a copy of the value, so modifying the returned value affects the original object. Syntax lookup( pathElements ) Arguments Returns (LuaJsonValue) Returns the value that exists at the specified path, ..."},"584":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_lookupByPath.htm",l:-1,t:"lookupByPath",i:0.00322515305959451,a:"The lookupByPath method returns the value at the specified path in the JSON array. This method does not make a copy of the value, so modifying the returned value affects the original object. Syntax lookupByPath( path ) Arguments Returns (LuaJsonValue) Returns the value that exists at the specified ..."},"585":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_object.htm",l:-1,t:"object",i:0.00048383567593424,a:"The object method gets the object, if the value is a JSON object. Syntax object() Returns (LuaJsonObject) A  LuaJsonObject  object that represents the JSON object. Example local fh = io.open(\"example_json.json\", \"r\")\nlocal file_content = fh:read(\"*all\")\nfh:close()\n\nlocal myJsonValue = ..."},"586":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_string.htm",l:-1,t:"string",i:0.00048383567593424,a:"The string method returns the JSON value as a string. Syntax string() Returns (String). The JSON value as a string. Example local fh = io.open(\"example_json.json\", \"r\")\nlocal file_content = fh:read(\"*all\")\nfh:close()\n    \nlocal myJsonValue = parse_json(file_content)\n\nprint(myJsonValue:string())\n"},"587":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_value.htm",l:-1,t:"value",i:0.00048383567593424,a:"The value method gets the value, if the JSON value is a simple type (a Boolean, float, integer, or string). This method returns a default value if one is specified and the value cannot be converted to the same type as the default. Syntax value( [default] ) Arguments Returns (lua_json_simple_type). A ..."},"588":{y:0,u:"../Content/Lua/LuaLog/_LUA_LuaLog.htm",l:-1,t:"LuaLog Methods",i:0.00265996044969071,a:"LuaLog Methods A LuaLog object provides the capability to use a log stream. You can obtain a LuaLog object for a log stream by using the function  get_log . If you have a LuaLog object called log you can call its methods using the \u0027:\u0027 operator. For example: log:write_line(level, message)"},"589":{y:0,u:"../Content/Lua/LuaLog/_LUA_write_line.htm",l:-1,t:"write_line",i:0.00153044876105292,a:"The write_line method writes a message to the log stream. Syntax write_line( level, message ) Arguments Example To write a log message from the ExecuteDocumentLua processor in  NiFi: local log = get_log()\nlog:write_line(log_level_normal(), \"doing something...\")\n\n-- or use the following ..."},"590":{y:0,u:"../Content/Lua/LuaLogService/_LUA__LuaLogService.htm",l:-1,t:"LuaLogService Methods",i:0.000491708756342909,a:"A LuaLogService object provides the capability to write messages to a custom log file. To write messages to standard log files, OpenText recommends using the function  get_log  instead. If you have a LuaLogService object called myLogService you can call its methods using the \u0027:\u0027 operator. For ..."},"591":{y:0,u:"../Content/Lua/LuaLogService/_LUA_LuaLogService_new.htm",l:-1,t:"LuaLogService:new",i:0.000539277477175072,a:"The constructor for a LuaLogService object (creates a new LuaLogService). Do not construct a new log service to write messages to log types that are defined in the Answer Server configuration file. Syntax LuaLogService:new( config ) Arguments Returns (LuaLogService). The new LuaLogService object. ..."},"592":{y:0,u:"../Content/Lua/LuaLogService/_LUA_get_log.htm",l:-1,t:"get_log",i:0.000539277477175072,a:"get_log The get_log method returns a LuaLog object that you can use to write log messages to a specified log type. Syntax get_log( type ) Arguments Returns (LuaLog). A  LuaLog  object."},"593":{y:0,u:"../Content/Lua/LuaRegexMatch/_LUA_LuaRegexMatch_Methods.htm",l:-1,t:"LuaRegexMatch Methods",i:0.00103766289035654,a:"A LuaRegexMatch object provides information about the matches for a regular expression found in a string. For example, the regex_search function returns a LuaRegexMatch object. If a match is found for a regular expression at multiple points in the string, you can use the next() method to get a ..."},"594":{y:0,u:"../Content/Lua/LuaRegexMatch/_LUA_length.htm",l:-1,t:"length",i:0.000576362898948472,a:"length The length method returns the length of the match. You can also retrieve the length of sub matches by specifying the submatch parameter. Syntax length( [ submatch ] ) Arguments Returns (Number). The length of the sub match."},"595":{y:0,u:"../Content/Lua/LuaRegexMatch/_LUA_next.htm",l:-1,t:"next",i:0.000576362898948472,a:"next The next method returns a LuaRegexMatch object for the next match. Syntax next() Returns (LuaRegexMatch). A LuaRegexMatch object for the next match, or nil if there are no matches following this one."},"596":{y:0,u:"../Content/Lua/LuaRegexMatch/_LUA_position.htm",l:-1,t:"position",i:0.000576362898948472,a:"The position method returns the position of the match in the string searched, where 1 refers to the first character in the string. You can also retrieve the position of sub matches by specifying the submatch parameter. Syntax position( [ submatch ] ) Arguments Returns (Number). The position of the ..."},"597":{y:0,u:"../Content/Lua/LuaRegexMatch/_LUA_size.htm",l:-1,t:"size",i:0.000576362898948472,a:"size The size method returns the total number of sub matches made for the current match, including the whole match (sub match 0). Syntax size() Returns (Number). The number of sub matches for the current match."},"598":{y:0,u:"../Content/Lua/LuaRegexMatch/_LUA_str.htm",l:-1,t:"str",i:0.000576362898948472,a:"str The str method returns the matched text. You can also retrieve the values of sub matches by specifying the submatch parameter. Syntax str( [ submatch ] ) Arguments Returns (String). The value of the sub match."},"599":{y:0,u:"../Content/Lua/LuaXmlDocument/_LUA_LuaXmlDocument_Methods.htm",l:-1,t:"LuaXmlDocument Methods",i:0.000519302037997666,a:"This section describes the methods provided by LuaXmlDocument objects. A LuaXmlDocument object provides methods for accessing information stored in XML format. You can create a LuaXmlDocument from a string containing XML using the parse_xml function. If you have a LuaXmlDocument object called xml ..."},"600":{y:0,u:"../Content/Lua/LuaXmlDocument/_LUA_root.htm",l:-1,t:"root",i:0.000488241183868299,a:"root The root method returns an LuaXmlNode, which is the root node of the XML document. Syntax root() Returns (LuaXmlNode). A LuaXmlNode object."},"601":{y:0,u:"../Content/Lua/LuaXmlDocument/_LUA_XPathExecute.htm",l:-1,t:"XPathExecute",i:0.000488241183868299,a:"XPathExecute The XPathExecute method returns a LuaXmlNodeSet, which is the result of the supplied XPath query. Syntax XPathExecute( xpathQuery ) Arguments Returns (LuaXmlNodeSet). A LuaXmlNodeSet object."},"602":{y:0,u:"../Content/Lua/LuaXmlDocument/_LUA_XPathRegisterNs.htm",l:-1,t:"XPathRegisterNs",i:0.000488241183868299,a:"XPathRegisterNs The XPathRegisterNs method registers a namespace with the XML parser. Syntax XPathRegisterNs( prefix, location ) Arguments Returns (Boolean). True if successful, False in case of error."},"603":{y:0,u:"../Content/Lua/LuaXmlDocument/_LUA_XPathValue.htm",l:-1,t:"XPathValue",i:0.000488241183868299,a:"XPathValue The XPathValue method returns the first occurrence of the value matching the XPath query. Syntax XPathValue( query ) Arguments Returns (String). A string of the value."},"604":{y:0,u:"../Content/Lua/LuaXmlDocument/_LUA_XPathValues.htm",l:-1,t:"XPathValues",i:0.000488241183868299,a:"The XPathValues method returns the values according to the XPath query. Syntax XPathValues( query ) Arguments Returns (Strings). The strings can be assigned to a table. To map the return values to a table, surround the function call with braces. For example: values = { xml:XPathValues(query) }"},"605":{y:0,u:"../Content/Lua/LuaXmlNodeSet/_LUA_LuaXmlNodeSet_Methods.htm",l:-1,t:"LuaXmlNodeSet Methods",i:0.000399959553818357,a:"LuaXmlNodeSet Methods A LuaXmlNodeSet object represents a set of XML nodes. If you have a LuaXmlNodeSet object called nodes you can call its methods using the \u0027:\u0027 operator. For example: nodes:size()"},"606":{y:0,u:"../Content/Lua/LuaXmlNodeSet/_LUA_at.htm",l:-1,t:"at",i:0.0005699428821386,a:"at The at method returns the LuaXmlNode at position position in the set. Syntax at( position ) Arguments Returns (LuaXmlNode)."},"607":{y:0,u:"../Content/Lua/LuaXmlNodeSet/_LUA_size.htm",l:-1,t:"size",i:0.0005699428821386,a:"size The size method returns the size of the node set. Syntax size() Returns (Number) An integer, the size of the node set."},"608":{y:0,u:"../Content/Lua/LuaXmlNode/_LUA_LuaXmlNode_Methods.htm",l:-1,t:"LuaXmlNode Methods",i:0.000399959553818357,a:"LuaXmlNode Methods A LuaXmlNode object represents a single node in an XML document.  If you have a LuaXmlNode object called node you can call its methods using the \u0027:\u0027 operator. For example: node:name()"},"609":{y:0,u:"../Content/Lua/LuaXmlNode/_LUA_attr.htm",l:-1,t:"attr",i:0.000433956219482406,a:"attr The attr method returns the first LuaXmlAttribute attribute object for the LuaXmlNode. If the name argument is specified, the method returns the first LuaXmlAttribute object with the specified name. Syntax attr( [name] ) Arguments Returns (LuaXmlAttribute). "},"610":{y:0,u:"../Content/Lua/LuaXmlNode/_LUA_content.htm",l:-1,t:"content",i:0.000433956219482406,a:"content The content method returns the content (text element) of the XML node. Syntax content() Returns (String). A string containing the content."},"611":{y:0,u:"../Content/Lua/LuaXmlNode/_LUA_firstChild.htm",l:-1,t:"firstChild",i:0.000433956219482406,a:"firstChild The firstChild method returns the LuaXmlNode that is the first child of this node. Syntax firstChild() Returns (LuaXmlNode)."},"612":{y:0,u:"../Content/Lua/LuaXmlNode/_LUA_lastChild.htm",l:-1,t:"lastChild",i:0.000433956219482406,a:"lastChild The lastChild method returns the LuaXmlNode that is the last child of this node. Syntax lastChild() Returns (LuaXmlNode)."},"613":{y:0,u:"../Content/Lua/LuaXmlNode/_LUA_name.htm",l:-1,t:"name",i:0.000433956219482406,a:"name The name method returns the name of the XML node. Syntax name() Returns (String). A string containing the name."},"614":{y:0,u:"../Content/Lua/LuaXmlNode/_LUA_next.htm",l:-1,t:"next",i:0.000433956219482406,a:"next The next method returns the LuaXmlNode that is the next sibling of this node. Syntax next() Returns (LuaXmlNode)."},"615":{y:0,u:"../Content/Lua/LuaXmlNode/_LUA_nodePath.htm",l:-1,t:"nodePath",i:0.000433956219482406,a:"nodePath The nodePath method returns the XML path to the node, which can be used in another XPath query. Syntax nodePath() Returns (String). A string containing the path."},"616":{y:0,u:"../Content/Lua/LuaXmlNode/_LUA_parent.htm",l:-1,t:"parent",i:0.000433956219482406,a:"parent The parent method returns the parent LuaXmlNode of the node. Syntax parent() Returns (LuaXmlNode)."},"617":{y:0,u:"../Content/Lua/LuaXmlNode/_LUA_prev.htm",l:-1,t:"prev",i:0.000433956219482406,a:"prev The prev method returns a LuaXmlNode that is the previous sibling of this node. Syntax prev() Returns (LuaXmlNode)."},"618":{y:0,u:"../Content/Lua/LuaXmlNode/_LUA_type.htm",l:-1,t:"type",i:0.000433956219482406,a:"The type method returns the type of the node as a string. Syntax type() Returns (String) A string containing the type. Possible values are: element_node comment_node element_decl attribute_node document_node attribute_decl text_node document_type_node entity_decl cdata_section_node ..."},"619":{y:0,u:"../Content/Lua/LuaXmlAttribute/_LUA_LuaXmlAttribute_Methods.htm",l:-1,t:"LuaXmlAttribute Methods",i:0.000399959553818357,a:"LuaXmlAttribute Methods A LuaXmlAttribute object represents an attribute on an XML element. If you have a LuaXmlAttribute object called attribute you can call its methods using the \u0027:\u0027 operator. For example: attribute:name()"},"620":{y:0,u:"../Content/Lua/LuaXmlAttribute/_LUA_name.htm",l:-1,t:"name",i:0.000484951217978479,a:"name The name method returns the name of this attribute. Syntax name() Returns (String). A string containing the name of the attribute."},"621":{y:0,u:"../Content/Lua/LuaXmlAttribute/_LUA_next.htm",l:-1,t:"next",i:0.000484951217978479,a:"next The next method returns a LuaXmlAttribute object for the next attribute in the parent element. Syntax next() Returns (LuaXmlAttribute)."},"622":{y:0,u:"../Content/Lua/LuaXmlAttribute/_LUA_prev.htm",l:-1,t:"prev",i:0.000484951217978479,a:"prev The prev method returns a LuaXmlAttribute object for the previous attribute in the parent element. Syntax prev() Returns (LuaXmlAttribute)."},"623":{y:0,u:"../Content/Lua/LuaXmlAttribute/_LUA_value.htm",l:-1,t:"value",i:0.000484951217978479,a:"value The value method returns the value of this attribute. Syntax value() Returns (String). A string containing the value of the attribute."},"624":{y:0,u:"../Content/AnswerServerLua/AnswerServerLua.htm",l:-1,t:"Answer Server Lua Functions and Methods Reference",i:0.000399959553818357,a:"This section describes the functions and methods that you can use in your Lua scripts that are specific to Answer Server. For information about the uses for your Lua scripts, and setting up debugging in Lua, refer to the  Answer Server Administration Guide."},"625":{y:0,u:"../Content/AnswerServerLua/ConversationLua.htm",l:-1,t:"Conversation Lua Functions and Methods Reference",i:0.000399959553818357,a:"Conversation Lua Functions and Methods Reference This section describes the functions and methods that you can use in your Lua scripts as part of your conversation tasks (see  TaskConfigurationFile ). "},"626":{y:0,u:"../Content/AnswerServerLua/Conversation/LuaConditionalRoutingRule_Methods.htm",l:-1,t:"LuaConditionalRoutingRule Methods",i:0.00081216939404861,a:"A LuaConditionalRoutingRule object is a conditional routing that maps some input text to a destination task.  If you have a LuaConditionalRoutingRule object, you can call its methods by using the \u0027:\u0027 operator. For example: routingRule:getMatch() Method Description getMatch Gets the input text part ..."},"627":{y:0,u:"../Content/AnswerServerLua/Conversation/getMatch.htm",l:-1,t:"getMatch",i:0.000630075012776339,a:"The getMatch method gets the input text part of a conditional routing rule from a LuaConditionalRoutingRule object. A LuaConditionalRoutingRule object is a conditional routing rule, with input text and the task to route to.  Syntax getMatch() Returns (strings) The input text from the rule. Example ..."},"628":{y:0,u:"../Content/AnswerServerLua/Conversation/getRouting.htm",l:-1,t:"getRouting",i:0.000630075012776339,a:"The getRouting method gets the task ID part of a conditional routing rule from a LuaConditionalRoutingRule object. A LuaConditionalRoutingRule object is a conditional routing rule, with input text and the task to route to.  Syntax getRouting() Returns (strings) The ID of the task to route to. ..."},"629":{y:0,u:"../Content/AnswerServerLua/Conversation/LuaConditionalRoutingRule_new.htm",l:-1,t:"LuaConditionalRoutingRule:new",i:0.00104228485300659,a:"The constructor for a LuaConditionalRoutingRule object (creates a new LuaConditionalRoutingRule object). A LuaConditionalRoutingRule object is a conditional routing that maps some user input to a destination task.  Syntax new(input_text, task_ID) Arguments Example local rule = ..."},"630":{y:0,u:"../Content/AnswerServerLua/Conversation/LuaConditionalRoutingTable_Methods.htm",l:-1,t:"LuaConditionalRoutingTable Methods",i:0.000399959553818357,a:"LuaConditionalRoutingTable Methods A LuaConditionalRoutingTable object is a table of conditional routing rules and prompts.  If you have a LuaConditionalRoutingTable object, you can call its methods by using the \u0027:\u0027 operator. For example: routingTable:getPrompt()"},"631":{y:0,u:"../Content/AnswerServerLua/Conversation/getPrompt_routingTable.htm",l:-1,t:"getPrompt",i:0.000484951217978479,a:"The getPrompt method gets the prompt part of a routingTable object. A routingTable object is a prompt string, and an array of LuaConditionalRoutingRules objects, which map some input text to a task.  In the case of a disambiguation Lua script, the prompt is initially the configured disambiguation ..."},"632":{y:0,u:"../Content/AnswerServerLua/Conversation/getRules.htm",l:-1,t:"getRules",i:0.000484951217978479,a:"The getRules method gets the current array of conditional routing rules to use for the current task after the Lua function completes. A conditional routing rule is defined by a LuaConditionalRoutingRule object  (see  LuaConditionalRoutingRule Methods ). Syntax getRules() Returns (array) An array of ..."},"633":{y:0,u:"../Content/AnswerServerLua/Conversation/setPrompt.htm",l:-1,t:"setPrompt",i:0.000399959553818357,a:"setPrompt The setPrompt method sets a text prompt to return in the current conversation task after the script is complete. This prompt replaces any existing prompts. Syntax setPrompt( new_prompt ) Arguments Example routingTable:setPrompt(\"I think you might mean one of the following:\")\n"},"634":{y:0,u:"../Content/AnswerServerLua/Conversation/setRules.htm",l:-1,t:"setRules",i:0.000484951217978479,a:"The setRules method sets an array of LuaConditionalRoutingRule objects  to use to route the user to the appropriate task after the script is complete. This rule replaces any existing rules. You create a LuaConditionalRoutingRule object by using the  LuaConditionalRoutingRule:new  constructor. Syntax ..."},"635":{y:0,u:"../Content/AnswerServerLua/Conversation/LuaUserPrompt_Methods.htm",l:-1,t:"LuaUserPrompt Methods",i:0.00124244003017631,a:"A LuaUserPrompt object is a prompt string, with optional metadata, to return to the user.  If you have a LuaUserPrompt object, you can call its methods by using the \u0027:\u0027 operator. For example: LuaUserPrompt:getPrompt() Method Description getChoices Gets the valid_choices metadata part of the prompt ..."},"636":{y:0,u:"../Content/AnswerServerLua/Conversation/getChoices.htm",l:-1,t:"getChoices",i:0.000663979014712358,a:"The getChoices method gets the valid_choices part of a prompt from a LuaUserPrompt object. A LuaUserPrompt object is a prompt string, with optional metadata, to return to the user.  Syntax getChoices() Returns (strings) The valid choices for the prompt. Example local choices = ..."},"637":{y:0,u:"../Content/AnswerServerLua/Conversation/getPrompt.htm",l:-1,t:"getPrompt",i:0.000663979014712358,a:"getPrompt The getPrompt method gets the text part of a prompt from a LuaUserPrompt object. A LuaUserPrompt object is a prompt string, with optional metadata, to return to the user.  Syntax getPrompt() Returns (string) The prompt text. Example local text = LuaUserPrompt:getPrompt()"},"638":{y:0,u:"../Content/AnswerServerLua/Conversation/getSuggestions.htm",l:-1,t:"getSuggestions",i:0.000663979014712358,a:"The getSuggestions method gets the suggestions part of a prompt from a LuaUserPrompt object. A LuaUserPrompt object is a prompt string, with optional metadata, to return to the user.  Syntax getSuggestions() Returns (strings) The suggestions for the prompt. Example local choices = ..."},"639":{y:0,u:"../Content/AnswerServerLua/Conversation/LuaUserPrompt_new.htm",l:-1,t:"LuaUserPrompt:new",i:0.00109424965084005,a:"The constructor for a LuaUserPrompt object (creates a new LuaUserPrompt object). A LuaUserPrompt object is a prompt string, with optional metadata, to return to the user.  Syntax new(text, valid_choices, suggestions) Arguments Example local prompt2 = LuaUserPrompt:new(\"The following cakes are ..."},"640":{y:0,u:"../Content/AnswerServerLua/Conversation/TaskUtils_Methods.htm",l:-1,t:"TaskUtils Methods",i:0.000399959553818357,a:"A TaskUtils object is an operation to perform with a conversation task. This object is the input to the function that you use for your conversation task (you specify the function to use in your task configuration JSON file).  If you have a TaskUtils object, you can call its methods by using the \u0027:\u0027 ..."},"641":{y:0,u:"../Content/AnswerServerLua/Conversation/ask.htm",l:-1,t:"ask",i:0.000421207469858388,a:"The ask method sends a question to the specified answer systems in an  Ask  action.  Syntax ask(question, systems, maxresults, disambiguation, queryparameters) Arguments Returns A list of  LuaXmlDocument  objects that represent the answers. Example function get_text(document, xpath)\n   return ..."},"642":{y:0,u:"../Content/AnswerServerLua/Conversation/clearAllSessionVars.htm",l:-1,t:"clearAllSessionVars",i:0.000421207469858388,a:"The clearAllSessionVars method deletes all session variables that have been set in the current conversation session. If you delete a session variable, and the current conversation task has a requirement to set the variable, the conversation task asks the user to provide a new value for the variable. ..."},"643":{y:0,u:"../Content/AnswerServerLua/Conversation/clearAllTaskVars.htm",l:-1,t:"clearAllTaskVars",i:0.000421207469858388,a:"clearAllTaskVars The clearAllTaskVars method deletes all task variables that have been set in the current task. If you delete variables during a task, the conversation task asks the user to provide a new value for the variables. Syntax clearAllTaskVars()"},"644":{y:0,u:"../Content/AnswerServerLua/Conversation/clearSessionVar.htm",l:-1,t:"clearSessionVar",i:0.000421207469858388,a:"The clearSessionVar method deletes a specified session variable, if it exists. If you delete a session variable, and the current conversation task has a requirement to set the variable, the conversation task asks the user to provide a new value for the variable. If the current conversation task does ..."},"645":{y:0,u:"../Content/AnswerServerLua/Conversation/clearTaskVar.htm",l:-1,t:"clearTaskVar",i:0.000421207469858388,a:"clearTaskVar The clearTaskVar method deletes a specified task variable, if it exists. If you delete a variable during a task, the conversation task asks the user to provide a new value for the variable. Syntax clearTaskVar ( key ) Arguments"},"646":{y:0,u:"../Content/AnswerServerLua/Conversation/getPrompts.htm",l:-1,t:"getPrompts",i:0.000421207469858388,a:"The getPrompts method gets the current table of prompts that the conversation task will return after the Lua function completes. A prompt is defined by a LuaUserPrompt object  (see  LuaUserPrompt Methods ). Syntax getPrompts() Returns (list) A list of LuaUserPrompt objects. Example local prompt1 = ..."},"647":{y:0,u:"../Content/AnswerServerLua/Conversation/getSessionVar.htm",l:-1,t:"getSessionVar",i:0.000421207469858388,a:"The getSessionVar method gets the value of a conversation session variable.  You define session variables in your task configuration JSON file, by creating a task requirement with the scope property set to session. Syntax getSessionVar( key ) Arguments Returns (strings) The value of the session ..."},"648":{y:0,u:"../Content/AnswerServerLua/Conversation/getTaskId.htm",l:-1,t:"getTaskId",i:0.000421207469858388,a:"getTaskId The getTaskId method gets the ID of the current task as a string. Syntax getTaskId() Returns (strings) The ID of the current task."},"649":{y:0,u:"../Content/AnswerServerLua/Conversation/getTaskVar.htm",l:-1,t:"getTaskVar",i:0.000421207469858388,a:"The getTaskVar method gets the value of a conversation task variable.  You define task variables in your task configuration JSON file, by creating a task requirement with the scope property set to local (the default). Syntax getTaskVar ( key ) Arguments Returns (strings) The value of the task ..."},"650":{y:0,u:"../Content/AnswerServerLua/Conversation/getTranscript.htm",l:-1,t:"getTranscript",i:0.000399959553818357,a:"The getTranscript method gets an enumerated table of history stage objects, which record the user input and Answer Server responses for the current conversation session. Syntax getTranscript() Returns (table) An enumerated table of history stage objects. Each stage contains the user text and Answer ..."},"651":{y:0,u:"../Content/AnswerServerLua/Conversation/responsePrompts.htm",l:-1,t:"responsePrompts",i:0.0005699428821386,a:"The responsePrompts method gets the table of prompts that the conversation task returned at a particular stage of the conversation. A prompt is defined by a LuaUserPrompt object  (see  LuaUserPrompt Methods ). Syntax responsePrompts() Returns (list) A list of LuaUserPrompt objects. Example local ..."},"652":{y:0,u:"../Content/AnswerServerLua/Conversation/userInput.htm",l:-1,t:"userInput",i:0.0005699428821386,a:"The userInput method gets the input text that the user supplied at a particular stage of the conversation. The history table from getTranscript does not include the current user text. To retrieve the current user text, use the  getUserText  method. Syntax userInput() Returns (string) The user text ..."},"653":{y:0,u:"../Content/AnswerServerLua/Conversation/getUserText.htm",l:-1,t:"getUserText",i:0.000905660493678408,a:"getUserText The getUserText method gets the text that the user has entered as a string. Syntax getUserText() Returns (strings) The user text."},"654":{y:0,u:"../Content/AnswerServerLua/Conversation/getValidator.htm",l:-1,t:"getValidator",i:0.000421207469858388,a:"The getValidator method returns a callable validator object. You can pass a string input to the validator object to validate some text. Syntax getValidator( id ) Arguments Returns A callable validator object, or nil if the parameter was not a valid validator ID. When you pass a string to the ..."},"655":{y:0,u:"../Content/AnswerServerLua/Conversation/markAsValid.htm",l:-1,t:"markAsValid",i:0.000421207469858388,a:"markAsValid The markAsValid method indicates whether input that a validator marked as invalid is actually valid. You can also use this function in a cancel action (in the user_cancel or system_cancel configuration objects) to override the cancellation. Syntax markAsValid( bool ) Arguments"},"656":{y:0,u:"../Content/AnswerServerLua/Conversation/setNextTask.htm",l:-1,t:"setNextTask",i:0.000421207469858388,a:"The setNextTask method sets the ID of the task that you want to run after the current task. You can use this method only in functions that you call from the post section of a task configuration, or in the user_cancel or system_cancel objects. For more information, refer to the  Answer Server ..."},"657":{y:0,u:"../Content/AnswerServerLua/Conversation/setPrompts.htm",l:-1,t:"setPrompts",i:0.000506199134018509,a:"The setPrompts method sets a list of LuaUserPrompt objects  to return in the current conversation task after the script is complete.  You create a LuaUserPrompt object by using the  LuaUserPrompt:new  constructor. Syntax setPrompts( prompts ) Arguments Example function choose_cake(taskUtils)\n   ..."},"658":{y:0,u:"../Content/AnswerServerLua/Conversation/setSessionVar.htm",l:-1,t:"setSessionVar",i:0.000421207469858388,a:"The setSessionVar method sets the value of a conversation session variable.   You define session variables in your task configuration JSON file, by creating a task requirement with the scope property set to session. Syntax setSessionVar( key, value) Arguments Example function greet(taskUtils)\n   ..."},"659":{y:0,u:"../Content/AnswerServerLua/Conversation/setTaskVar.htm",l:-1,t:"setTaskVar",i:0.000421207469858388,a:"The setTaskVar method sets the value of a conversation task variable.   You define task variables in your task configuration JSON file, by creating a task requirement with the scope property set to local (the default). Syntax setTaskVar( key, value) Arguments Example function ..."},"660":{y:0,u:"../Content/AnswerServerLua/FactBankLua.htm",l:-1,t:"Fact Bank Lua Functions and Methods Reference",i:0.000399959553818357,a:"Fact Bank Lua Functions and Methods Reference This section describes the functions and methods that you can use in your Lua scripts to create a custom fact bank back end (see  BackendType )."},"661":{y:0,u:"../Content/AnswerServerLua/LuaIncompleteFact_Methods.htm",l:-1,t:"LuaIncompleteFact Methods",i:0.000507238218645624,a:"A LuaIncompleteFact object represents a parsing of the input question. This object is the input to the entry function that you use for your Lua Fact Bank (by default, the fetch function).  The LuaIncompleteFact object has at most one target element missing, which the Lua script must attempt to find ..."},"662":{y:0,u:"../Content/AnswerServerLua/getEntity.htm",l:-1,t:"getEntity",i:0.000461552972709866,a:"The getEntity method returns the entity that you want to find facts for. If the incomplete fact target is the entity, this method returns an empty string. Syntax getEntity() Returns (string) The entity name. Example local entityName = incomplete:getEntity()\nif \"QGBR\" == entityName then\n  ..."},"663":{y:0,u:"../Content/AnswerServerLua/getProperties.htm",l:-1,t:"getProperties",i:0.000461552972709866,a:"The getProperties method returns the array of properties for this fact. Syntax getProperties() Returns (array of LuaIncompleteFactProperty objects) An array of properties for the fact. See  LuaIncompleteFactProperty Methods . Example local props = incomplete:getProperties()\nfor i=1,#props do\n  ..."},"664":{y:0,u:"../Content/AnswerServerLua/getTargetDepth.htm",l:-1,t:"getTargetDepth",i:0.000461552972709866,a:"The getGetTargetDepth method returns the target of this incomplete fact (that is, the piece of information that you want to find).  See also:  getTargetPaths Syntax getTargetDepth() Returns (Integer). A number that represents the target information for the fact. The following table describes the ..."},"665":{y:0,u:"../Content/AnswerServerLua/getTargetPaths.htm",l:-1,t:"getTargetPaths",i:0.000853874250197215,a:"The getTargetPaths method returns the target of an incomplete fact. Syntax getTargetPaths() Returns (unsigned integers) An array of unsigned integers. The first value (if present) is the 0-indexed property of interest. The second value (if present) is the 0-indexed qualifier for the previously ..."},"666":{y:0,u:"../Content/AnswerServerLua/initToCodifiedFact.htm",l:-1,t:"initToCodifiedFact",i:0.000568831637537133,a:"The initToCodifiedFact method generates a fact to return, which must be completed by the script. Syntax initToCodifiedFact() Returns (LuaCodifiedFact) The codified fact object. See  LuaCodifiedFact Methods . Example local fact = incomplete:initToCodifiedFact()\nfact:setEntity(\"QGBR\")\n..."},"667":{y:0,u:"../Content/AnswerServerLua/LuaIncompleteFactProperty_Methods.htm",l:-1,t:"LuaIncompleteFactProperty Methods",i:0.000853874250197215,a:"A LuaIncompleteFactProperty object is a property of an incomplete fact.  A  LuaIncompleteFactProperty object can have zero or more LuaIncompleteFactQualifier objects. See  LuaIncompleteFactQualifier Methods  . If you have a LuaIncompleteFactProperty object called props, you can call its methods by ..."},"668":{y:0,u:"../Content/AnswerServerLua/getCode.htm",l:-1,t:"getCode",i:0.000848304780080894,a:"The getCode method gets an array of the codes for a property or qualifier. This array usually contains a single item unless the property or qualifier is negated (see  getNegated ). Syntax getCode() Returns (strings) An array of codes for the properties or qualifiers. Examples For a ..."},"669":{y:0,u:"../Content/AnswerServerLua/getNegated.htm",l:-1,t:"getNegated",i:0.00229042840259225,a:"The getNegated method returns whether the property or qualifier is negative (that is, something that you do not want to match).  Syntax getNegated() Returns (Boolean) A Boolean that specifies whether the property or qualifier is negated (true for negative properties and qualifiers, false otherwise). ..."},"670":{y:0,u:"../Content/AnswerServerLua/getQualifiers.htm",l:-1,t:"getQualifiers",i:0.00054511868643211,a:"The getQualifiers method returns an array of qualifiers for this property. Syntax getQualifiers() Returns (array of LuaIncompleteFactQualifier objects) An array of qualifiers for the property. See  LuaIncompleteFactQualifier Methods . Example local props = incomplete:getProperties()\nfor i=1,#props ..."},"671":{y:0,u:"../Content/AnswerServerLua/getVal.htm",l:-1,t:"getVal",i:0.000848304780080894,a:"The getVal method returns an array of the values for this property or qualifier. This array usually contains a single item unless the property or qualifier is negated (see  getNegated ). Syntax getVal() Returns (strings) An array of string values for this property or qualifier. Examples For a ..."},"672":{y:0,u:"../Content/AnswerServerLua/LuaIncompleteFactQualifier_Methods.htm",l:-1,t:"LuaIncompleteFactQualifier Methods",i:0.00107006455503691,a:"LuaIncompleteFactQualifier Methods A LuaIncompleteFactQualifier object is a qualifier for a property of an incomplete fact. If you have a LuaIncompleteFactQualifier object called quals, you can call its methods by using the \u0027:\u0027 operator. For example: quals:getNegated()"},"673":{y:0,u:"../Content/AnswerServerLua/LuaCodifiedFact_Methods.htm",l:-1,t:"LuaCodifiedFact Methods",i:0.000883468106905783,a:"A LuaCodifiedFact object is a complete fact. You initialize this fact from a LuaIncompleteFact object by using the initToCodifiedFact method (see  LuaIncompleteFact Methods  and  initToCodifiedFact ). A LuaCodifiedFact object must not have any missing elements (for example, it must have an entity ..."},"674":{y:0,u:"../Content/AnswerServerLua/setEntity.htm",l:-1,t:"setEntity",i:0.000507238218645624,a:"setEntity The setEntity method sets the entity that this fact describes. Syntax setEntity(entity) Arguments Example local fact = incomplete:initToCodifiedFact()\nfact:setEntity(\"QGBR\")\n..."},"675":{y:0,u:"../Content/AnswerServerLua/setProperties.htm",l:-1,t:"setProperties",i:0.000507238218645624,a:"setProperties The setProperties method sets the properties for this fact. Syntax setProperties(LuaCodifiedFactProperty) Arguments Example local fact = incomplete:initToCodifiedFact()\nfact:setProperties({LuaCodifiedFactProperty:new(\"QAGE\",\"42\", nil)})\n..."},"676":{y:0,u:"../Content/AnswerServerLua/setSource.htm",l:-1,t:"setSource",i:0.000507238218645624,a:"setSource The setSource method sets the source of the information for this fact. Syntax setSource(source) Arguments Example local fact = incomplete:initToCodifiedFact()\nfact:setSource(\"Externally held data\")\n..."},});